/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.egg.CapabilityEgg;
import net.dries007.tfc.api.capability.egg.IEgg;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIFindNest;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityChickenTFC
extends EntityAnimalTFC
implements ILivestock {
    private static final DataParameter<Long> LAID = EntityDataManager.func_187226_a(EntityChickenTFC.class, EntitiesTFC.getLongDataSerializer());
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;

    public EntityChickenTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityChickenTFC.getRandomGrowth(ConfigTFC.Animals.CHICKEN.adulthood, ConfigTFC.Animals.CHICKEN.elder));
    }

    public EntityChickenTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.6f, 0.8f);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!BiomesTFC.isOceanicBiome(biome) && !BiomesTFC.isBeachBiome(biome) && biomeType == BiomeHelper.BiomeType.PLAINS) {
            return ConfigTFC.Animals.CHICKEN.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.MALE_AND_FEMALES;
    }

    @Override
    public int getMinGroupSize() {
        return 3;
    }

    @Override
    public int getMaxGroupSize() {
        return 5;
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.45f;
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.CHICKEN.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.CHICKEN.elder;
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.OVIPAROUS;
    }

    @Override
    public boolean isReadyForAnimalProduct() {
        return this.getFamiliarity() > 0.15f && this.hasEggs();
    }

    @Override
    public List<ItemStack> getProducts() {
        IEgg cap;
        ArrayList<ItemStack> eggs = new ArrayList<ItemStack>();
        ItemStack egg = new ItemStack(Items.field_151110_aK);
        if (this.isFertilized() && (cap = (IEgg)egg.getCapability(CapabilityEgg.CAPABILITY, null)) != null) {
            EntityChickenTFC chick = new EntityChickenTFC(this.field_70170_p);
            chick.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            cap.setFertilized((Entity)chick, (long)ConfigTFC.Animals.CHICKEN.hatch + CalendarTFC.PLAYER_TIME.getTotalDays());
        }
        eggs.add(egg);
        return eggs;
    }

    @Override
    public void setProductsCooldown() {
        this.setLaidTicks(CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)ConfigTFC.Animals.CHICKEN.eggTicks + this.getLaidTicks() - CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public TextComponentTranslation getTooltip() {
        if (this.getGender() == IAnimalTFC.Gender.MALE) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.male_egg", new Object[0]);
        }
        if (this.getAge() == IAnimalTFC.Age.OLD) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.old", new Object[]{this.getAnimalName()});
        }
        if (this.getAge() == IAnimalTFC.Age.CHILD) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.young", new Object[]{this.getAnimalName()});
        }
        if (this.getFamiliarity() <= 0.15f) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.low_familiarity", new Object[]{this.getAnimalName()});
        }
        if (!this.hasEggs()) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.no_egg", new Object[]{this.getAnimalName()});
        }
        return null;
    }

    public long getLaidTicks() {
        return (Long)this.field_70180_af.func_187225_a(LAID);
    }

    protected void setLaidTicks(long ticks) {
        this.field_70180_af.func_187227_b(LAID, (Object)ticks);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_184651_r() {
        EntityAnimalTFC.addCommonLivestockAI(this, 1.3);
        EntityAnimalTFC.addCommonPreyAI(this, 1.3);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFindNest(this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_CHICKEN;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    protected boolean hasEggs() {
        return this.getGender() == IAnimalTFC.Gender.FEMALE && this.getAge() == IAnimalTFC.Age.ADULT && (this.getLaidTicks() <= 0L || this.getProductsCooldown() <= 0L);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LAID, (Object)0L);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getClass() == EntityChickenTFC.class && this.getGender() == IAnimalTFC.Gender.MALE && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && CalendarTFC.CALENDAR_TIME.getHourOfDay() == 6 && this.field_70146_Z.nextInt(600) == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), TFCSounds.ANIMAL_ROOSTER_CRY, SoundCategory.AMBIENT, 0.8f, 1.0f);
        }
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74772_a("laidTicks", this.getLaidTicks());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setLaidTicks(nbt.func_74763_f("laidTicks"));
    }

    @Override
    public double getOldDeathChance() {
        return ConfigTFC.Animals.CHICKEN.oldDeathChance;
    }
}

